#include <bits/stdc++.h>

using namespace std;

const int MAXN = 1000100;
int l[MAXN], r[MAXN];
int val[MAXN];
vector <pair <int, int>> ve[MAXN];
long long sol[MAXN];
long long podstablo[MAXN];

struct Kockica {
  int a = 3, b = 5, c = 1;

  int value() {
    return a;
  }

  void left() {
    int d = b;
    b = a;
    a = 7 - d;
  }

  void right() {
    int d = c;
    c = a;
    a = 7 - d;
  }
} kockica;

int moves;
long long s;
int dis[MAXN], fin[MAXN];
int t = 0;

long long dfs(int x) {
  dis[x] = ++t;
  val[x] = kockica.value();
  moves++;
  podstablo[x] += kockica.value();
  if (l[x] > 0) {
    kockica.left();
    podstablo[x] += dfs(l[x]);
    kockica.left();
    kockica.left();
    kockica.left();
    moves++;
    podstablo[x] += kockica.value();
  }
  if (r[x] > 0) {
    kockica.right();
    podstablo[x] += dfs(r[x]);
    kockica.right();
    kockica.right();
    kockica.right();
    moves++;
    podstablo[x] += kockica.value();
  }
  fin[x] = t;
  return podstablo[x];
}

long long bit[MAXN];

void add(int x, int v) {
  for (x; x < MAXN; x += x & -x) bit[x] += v;
  return;
}

long long sum(int x) {
  long long out = 0;
  for (x; x > 0; x -= x & -x) out += bit[x];
  return out;
}


void rek(int x) {
  add(dis[x], val[x]);
  moves++;
  for (auto [i, y] : ve[moves]) sol[i] += sum(fin[y]) - sum(dis[y] - 1);
  if (l[x] > 0) {
    kockica.left();
    rek(l[x]);
    kockica.left();
    kockica.left();
    kockica.left();
    add(dis[x], val[x]);
    moves++;
    for (auto [i, y] : ve[moves]) sol[i] += sum(fin[y]) - sum(dis[y] - 1);
  }
  if (r[x] > 0) {
    kockica.right();
    rek(r[x]);
    kockica.right();
    kockica.right();
    kockica.right();
    add(dis[x], val[x]);
    moves++;
    for (auto [i, y] : ve[moves]) sol[i] += sum(fin[y]) - sum(dis[y] - 1);
  }
  return;
}

int main() {
  ios_base::sync_with_stdio(false);

  int n;
  cin >> n;
  for (int i = 0; i < n; i++) {
    cin >> l[i] >> r[i];
    l[i]--;
    r[i]--;
  }

  dfs(0);
  moves -= 1;
  podstablo[0] -= kockica.value();

  int q;
  cin >> q;
  for (int i = 0; i < q; i++) {
    int x;
    long long k;
    cin >> k >> x;
    k++;
    ve[k % moves].push_back({i, x - 1});
    sol[i] = podstablo[x - 1] * (k / moves);
  }

  moves = 0;
  rek(0);

  for (int i = 0; i < q; i++) cout << sol[i] << "\n";

  return 0;
}
